unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, ComCtrls, ExtCtrls, ActnList, StdCtrls, Grids, DBGrids;

type
  TFMain = class(TForm)
    Panel1: TPanel;
    StatusBar1: TStatusBar;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    ActionList1: TActionList;
    ActionClose: TAction;
    ActionRun: TAction;
    Label1: TLabel;
    Shape: TShape;
    Panel2: TPanel;
    DBGrid: TDBGrid;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    ActionInsert: TAction;
    ActionEdit: TAction;
    ActionDelete: TAction;
    procedure ActionCloseExecute(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ActionDeleteExecute(Sender: TObject);
    procedure DBGridKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ActionInsertExecute(Sender: TObject);
    procedure ActionEditExecute(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }

    procedure  my_insert();
    procedure  my_edit();
    procedure  my_delete();
  end;

var
  FMain: TFMain;

implementation
{$R *.dfm}
Uses
   DataModule,
   FormOsoby;

procedure TFMain.ActionCloseExecute(Sender: TObject);
begin
   Close();
end;

procedure TFMain.FormActivate(Sender: TObject);
begin
   if DM.ADOConnection.Connected  = True then begin
      Shape.Brush.Color := clGreen;
   end
   else begin
      Shape.Brush.Color := clRed;
   end;
end;

procedure TFMain.FormCreate(Sender: TObject);
begin
   DM.ADODataSet.Active := True;
end;

procedure TFMain.FormDestroy(Sender: TObject);
begin
   DM.ADODataSet.Active := False;
end;

procedure TFMain.ActionDeleteExecute(Sender: TObject);
begin
   my_delete();
end;

procedure TFMain.DBGridKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
   if Key = VK_INSERT then begin
      my_insert();
   end;

   if Key = VK_RETURN then begin
      my_edit();
   end;

   if Key = VK_DELETE then begin
      my_delete();
   end;
end;

procedure TFMain.my_insert();
var
   Res : TModalResult;

begin
   FOsoby := TFOsoby.Create(Self, False);
   try
      res := FOsoby.ShowModal();
      if res = mrOK then begin

      end;
   finally
      FreeAndNil(FOsoby);
      DBGrid.SetFocus();      
   end;
end;

procedure TFMain.my_edit();
var
   Res : TModalResult;

begin
   // ma sens tylko gdy s jakiekolwiek rekordy
   if DM.ADODataSetBrowseIDOSOBY.IsNull then begin
      EXIT;
   end;

   FOsoby := TFOsoby.Create(Self, True);
   try
      res := FOsoby.ShowModal();
      if res = mrOK then begin

      end;
   finally
      FreeAndNil(FOsoby);
      DBGrid.SetFocus();
   end;
end;

procedure TFMain.ActionInsertExecute(Sender: TObject);
begin
   my_insert();
end;

procedure TFMain.ActionEditExecute(Sender: TObject);
begin
   my_edit();
end;

procedure TFMain.my_delete();
var
   id : Integer;

begin
   // ma sens jeeli istniej rekordy
   if DM.ADODataSetBrowseIDOSOBY.IsNull then begin
      EXIT;
   end;

   if MessageBox(0, PChar('Usun rekord ?'), 'Ostrzeenie', MB_YESNO ) = IDYES then begin
      // odczytuj dane aktualnego rekordu
      id := DM.ADODataSetBrowse.FieldByName('IDOSOBY').AsInteger;

      try
         DM.adocDELETE.Parameters.ParamByName('IDOSOBY').Value := id;
         DM.adocDELETE.Execute();
      finally
         DM.ADODataSetBrowse.Close();
         DM.ADODataSetBrowse.Open();
         DBGrid.SetFocus();
      end;
   end;
end;

end.

